
plugin simpleManipulator arnoldlight_radiusmanip
    name:~ARNOLD_LIGHT_RADIUS_MANIP_NAME~
    invisible:true
(
    local greenColor =  colorMan.getColor #manipulatorsActive
    local redColor =    colorMan.getColor #manipulatorsSelected
	local offsetLength = 0.0  -- AF (3/23/01) Used for mouse tracking

    on canManipulate target do
	(
		if not hasProperty target #shapeType then
		(
			return false
		)
		else
		(
			shapeType = target.shapeType
			if (shapeType != 0 and shapeType != 2 and shapeType != 4 and shapeType != 7) then
			(
				return false
			)
			else
			(
				return hasProperty target #lightRadius
			)
		)
	)

    on updateGizmos do
    (
        this.clearGizmos()
        
        giz = manip.makeCircle [0,0,0] (target.lightRadius * 1.01) 28

        this.addGizmoShape giz 0 greenColor redColor  
		
        return node.name + " " + ~ARNOLD_LIGHT_RADIUS_MANIP_RADIUS~ + " = " + target.lightRadius as string 
    )

    on mouseMove m which do
    (
        local pl = manip.makePlaneFromNormal z_axis [0, 0, 0],
        projectedPoint = [0,0,0]
		
        viewRay = this.getLocalViewRay m

        res = pl.intersect viewRay &projectedPoint
    
        if (res) then
		(
			target.lightRadius = (length projectedPoint) / 1.01
			offsetLength = 0.0
			return true
		)

		-- Plan B : the point wasn't on the plane because the plane 
		-- was parallel to view or close to it.  Use the plane perpendicular to the view instead
		pl = manip.makePlaneFromNormal viewRay.dir [0, 0, 0]
		projectedPoint = [0,0,0]
		res = pl.intersect viewRay &projectedPoint
		if (res) then 
		(  
			if offsetLength == 0.0 then 
				offsetLength = target.lightRadius - (length projectedPoint)
			target.lightRadius = ((length projectedPoint) + offsetLength) / 1.01
		)
    )
	
	on MouseDown m which do
	(
		offsetLength = 0.0
	)
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAdEj5fO1WRBDk+It1IB4HgCMoHtBQYrbZ3
-- 5/OtPlrnk0JIUglwRClBobhw8ccxpMXbzXTIsEgGJsJITgYAPbc8wzp+eXSsQv9p
-- Ga3gXAtODE2S+k5r2KFIQ+zB6BD0lGWW7Th20Jl7QzVdIu2T8v+5s8bmJ7u7FSPM
-- ZfaDTimAqzTFW/pknflcRDeCnHk8s+TQdqve1hOnemUHoz+otcy9duh+0PixLBfh
-- beOmYez7QxWkKsrmBUZsHjECD+FY9aNaP6kdHYnMjXJVVE46yXa3gsINModm6NDG
-- YzVLVnqjssJNsyskLHZ53gnCBYHsiv0tTmHMruetCopCRABLpX+d
-- -----END-SIGNATURE-----